package com.qboxus.tictic.activitesfragments.livestreaming.activities;


import android.os.Bundle;
import android.util.Log;
import android.view.SurfaceView;

import com.qboxus.tictic.activitesfragments.livestreaming.Constants;
import com.qboxus.tictic.activitesfragments.livestreaming.rtc.EventHandler;
import com.qboxus.tictic.simpleclasses.Functions;
import com.qboxus.tictic.simpleclasses.Variables;

import io.agora.rtc2.video.VideoCanvas;
import io.agora.rtc2.video.VideoEncoderConfiguration;

public abstract class RtcBaseMultiviewActivity extends BaseActivity implements EventHandler {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public void refreshStreamingConnection(String channelName) {
        config().setUid(Functions.getSharedPreference(this).getString(Variables.U_ID, ""));
        config().setChannelName(channelName);
        registerRtcEventHandler(this);
        configVideo();
        joinChannel();
    }

    public void removeStreamingConnection() {
        removeRtcEventHandler(this);
        rtcEngine().leaveChannel();
    }

    public String getChannelName() {
        return config().getChannelName();
    }

    private void configVideo() {
        VideoEncoderConfiguration configuration = new VideoEncoderConfiguration(
                Constants.VIDEO_DIMENSIONS[config().getVideoDimenIndex()],
                VideoEncoderConfiguration.FRAME_RATE.FRAME_RATE_FPS_15,
                VideoEncoderConfiguration.STANDARD_BITRATE,
                VideoEncoderConfiguration.ORIENTATION_MODE.ORIENTATION_MODE_FIXED_PORTRAIT
        );
        rtcEngine().setVideoEncoderConfiguration(configuration);
    }

    private void joinChannel() {
        rtcEngine().joinChannel(null, config().getChannelName(), "", Integer.parseInt(config().getUid()));

    }

    protected SurfaceView prepareRtcVideo(int uid, boolean local) {
        SurfaceView surface = new SurfaceView(getApplicationContext());
        surface.setZOrderMediaOverlay(true);

        if (local) {
            rtcEngine().setupLocalVideo(
                    new VideoCanvas(
                            surface,
                            VideoCanvas.RENDER_MODE_HIDDEN,
                            0)
            );
        } else {
            rtcEngine().setupRemoteVideo(
                    new VideoCanvas(
                            surface,
                            VideoCanvas.RENDER_MODE_HIDDEN,
                            uid)
            );
        }
        return surface;
    }

    protected void removeRtcVideo(int uid, boolean local) {
        if (local) {
            Log.d(com.qboxus.tictic.Constants.tag, "local True: ");
            rtcEngine().setupLocalVideo(null);
        } else {
            Log.d(com.qboxus.tictic.Constants.tag, "local false: ");
            rtcEngine().setupRemoteVideo(new VideoCanvas(null, VideoCanvas.RENDER_MODE_HIDDEN, uid));
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        removeRtcEventHandler(this);
        rtcEngine().leaveChannel();
    }


}
